/*
 * Decompiled with CFR 0.152.
 */
package formules;

import formules.FormuleAtomique;
import formules.FormuleExposant;
import formules.FormuleFraction;
import formules.FormuleIndice;
import formules.FormuleIntegrale;
import formules.FormuleLimite;
import formules.FormuleOperateur;
import formules.FormuleProduit;
import formules.FormuleRacine;
import formules.FormuleSomme;
import formules.FormuleSymbole;
import formules.FormuleVecteur;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import symboles.ListeSymboles;
import symboles.NomFormules;
import symboles.Symboles;

public abstract class Formule
implements Symboles,
NomFormules,
Serializable {
    private String sPrefixeFormule = "";
    private String sDelimiteurBlocO = "";
    private String sDelimiteurBlocF = "";

    public abstract void ajouterFormule(Formule var1);

    public abstract ArrayList getLesFormules();

    public abstract String getFormuleLatex();

    public abstract String getName();

    public abstract String getMembre(Formule var1);

    public abstract String getListeName(int var1);

    public abstract boolean isBlocNecessaire();

    protected void setPrefixeFormule(String psFormuleLatex) {
        this.sPrefixeFormule = psFormuleLatex;
    }

    protected String getPrefixeFormule() {
        return this.sPrefixeFormule;
    }

    protected void setDelimiteurBlocO(char pcChar) {
        this.sDelimiteurBlocO = "" + pcChar;
    }

    protected String getDelimiteurBlocO() {
        return !this.sDelimiteurBlocO.equals("") ? this.sDelimiteurBlocO : "";
    }

    protected void setDelimiteurBlocF(char pcChar) {
        this.sDelimiteurBlocF = "" + pcChar;
    }

    protected String getDelimiteurBlocF() {
        return !this.sDelimiteurBlocF.equals("") ? this.sDelimiteurBlocF : "";
    }

    protected void setDelimiteurBlocOF(char pcBloc) {
        this.setDelimiteurBlocO(pcBloc);
        switch (pcBloc) {
            case '{': {
                this.setDelimiteurBlocF('}');
                break;
            }
            case '[': {
                this.setDelimiteurBlocF(']');
            }
        }
    }

    public static String parser(String psNom, String psParam1, String psParam2) {
        if (psNom.equals("Fraction")) {
            return new FormuleFraction(Formule.parse(psParam1), Formule.parse(psParam2)).getFormuleLatex();
        }
        if (psNom.equals("Vecteur")) {
            return new FormuleVecteur(Formule.parse(psParam1)).getFormuleLatex();
        }
        if (psNom.equals("Limite")) {
            return new FormuleLimite(Formule.parse(psParam1)).getFormuleLatex();
        }
        if (psNom.equals("Racine")) {
            return new FormuleRacine(Formule.parse(psParam1), Formule.parse(psParam2)).getFormuleLatex();
        }
        if (psNom.equals("Integrale")) {
            return new FormuleIntegrale(Formule.parse(psParam1), Formule.parse(psParam2)).getFormuleLatex();
        }
        if (psNom.equals("Somme")) {
            return new FormuleSomme(Formule.parse(psParam1), Formule.parse(psParam2)).getFormuleLatex();
        }
        if (psNom.equals("Produit")) {
            return new FormuleProduit(Formule.parse(psParam1), Formule.parse(psParam2)).getFormuleLatex();
        }
        if (psNom.equals("Indice")) {
            return new FormuleIndice(Formule.parse(psParam1)).getFormuleLatex();
        }
        if (psNom.equals("Exposant")) {
            return new FormuleExposant(Formule.parse(psParam1)).getFormuleLatex();
        }
        if (psNom.equals("Symbole")) {
            return new FormuleSymbole(String.valueOf('\\') + psParam1).getFormuleLatex();
        }
        return "";
    }

    public static Formule parse(String psFormuleLatex) {
        Formule oLaFormule = new FormuleOperateur();
        if (psFormuleLatex.equals("")) {
            oLaFormule = new FormuleAtomique("");
        }
        String sFlux = "";
        while (!psFormuleLatex.equals("")) {
            String sBas;
            int iPosit = 0;
            iPosit = Formule.parsing("^[^\\\\\\{\\[\\_\\^]*[\\\\\\{\\[\\_\\^.]{1}", psFormuleLatex);
            if (iPosit >= 1) {
                sFlux = String.valueOf(sFlux) + psFormuleLatex.substring(0, iPosit);
                psFormuleLatex = psFormuleLatex.substring(iPosit);
                oLaFormule = Formule.creationFormule(oLaFormule, new FormuleAtomique(sFlux), psFormuleLatex);
                sFlux = "";
                continue;
            }
            iPosit = Formule.parsing("^\\\\(int|sum|prod|frac|sqrt|lim|vec|\\_|\\^)\\?$", psFormuleLatex);
            if (iPosit >= 1) {
                sFlux = psFormuleLatex.substring(0, iPosit);
                psFormuleLatex = "";
                if (sFlux.equals("\\frac")) {
                    oLaFormule = new FormuleFraction(Formule.parse("Num\u00e9rateur"), Formule.parse("D\u00e9nominateur"));
                    continue;
                }
                if (sFlux.equals("\\vec")) {
                    oLaFormule = new FormuleVecteur(Formule.parse("Expression"));
                    continue;
                }
                if (sFlux.equals("\\lim")) {
                    oLaFormule = new FormuleLimite(new FormuleIndice(Formule.parse("Expression")));
                    continue;
                }
                if (sFlux.equals("\\sqrt")) {
                    oLaFormule = new FormuleRacine(Formule.parse("Ordre"), Formule.parse("Radicande"));
                    continue;
                }
                if (sFlux.equals("\\int")) {
                    oLaFormule = new FormuleIntegrale(new FormuleIndice(Formule.parse("Borne inf\u00e9rieure")), new FormuleExposant(Formule.parse("Borne sup\u00e9rieure")));
                    continue;
                }
                if (sFlux.equals("\\sum")) {
                    oLaFormule = new FormuleSomme(new FormuleIndice(Formule.parse("Borne inf\u00e9rieure")), new FormuleExposant(Formule.parse("Borne sup\u00e9rieure")));
                    continue;
                }
                if (sFlux.equals("\\prod")) {
                    oLaFormule = new FormuleProduit(new FormuleIndice(Formule.parse("Borne inf\u00e9rieure")), new FormuleExposant(Formule.parse("Borne sup\u00e9rieure")));
                    continue;
                }
                if (sFlux.equals("\\_")) {
                    oLaFormule = new FormuleIndice(Formule.parse("Expression"));
                    continue;
                }
                if (!sFlux.equals("\\^")) continue;
                oLaFormule = new FormuleExposant(Formule.parse("Expression"));
                continue;
            }
            iPosit = Formule.parsing("^\\\\(int|sum|prod|frac|sqrt|lim|vec)[^a-zA-Z]{1}", psFormuleLatex);
            if (iPosit >= 1) {
                sFlux = psFormuleLatex.substring(0, iPosit);
                psFormuleLatex = psFormuleLatex.substring(iPosit);
                if (sFlux.equals("\\frac")) {
                    String sNum = Formule.retourneBloc('{', '}', psFormuleLatex);
                    psFormuleLatex = psFormuleLatex.substring(sNum.length());
                    sNum = Formule.suppressionDelimiteurs(sNum);
                    String sDenom = Formule.retourneBloc('{', '}', psFormuleLatex);
                    psFormuleLatex = psFormuleLatex.substring(sDenom.length());
                    sDenom = Formule.suppressionDelimiteurs(sDenom);
                    oLaFormule = Formule.creationFormule(oLaFormule, new FormuleFraction(Formule.parse(sNum), Formule.parse(sDenom)), psFormuleLatex);
                } else if (sFlux.equals("\\vec")) {
                    sBas = Formule.retourneBloc('{', '}', psFormuleLatex);
                    psFormuleLatex = psFormuleLatex.substring(sBas.length());
                    sBas = Formule.suppressionDelimiteurs(sBas);
                    oLaFormule = Formule.creationFormule(oLaFormule, new FormuleVecteur(Formule.parse(sBas)), psFormuleLatex);
                } else if (sFlux.equals("\\lim")) {
                    sBas = Formule.choixBlocMacroAtome(psFormuleLatex, "_", '_');
                    psFormuleLatex = psFormuleLatex.substring(sBas.length());
                    oLaFormule = Formule.creationFormule(oLaFormule, new FormuleLimite(Formule.parse(sBas)), psFormuleLatex);
                } else if (sFlux.equals("\\sqrt")) {
                    String sOrdre = Formule.retourneBloc('[', ']', psFormuleLatex);
                    psFormuleLatex = psFormuleLatex.substring(sOrdre.length());
                    sOrdre = Formule.suppressionDelimiteurs(sOrdre);
                    String sRadic = Formule.retourneBloc('{', '}', psFormuleLatex);
                    psFormuleLatex = psFormuleLatex.substring(sRadic.length());
                    sRadic = Formule.suppressionDelimiteurs(sRadic);
                    oLaFormule = Formule.creationFormule(oLaFormule, new FormuleRacine(Formule.parse(sOrdre), Formule.parse(sRadic)), psFormuleLatex);
                } else if (sFlux.equals("\\int") || sFlux.equals("\\prod") || sFlux.equals("\\sum")) {
                    sBas = Formule.choixBlocMacroAtome(psFormuleLatex, "_", '_');
                    psFormuleLatex = psFormuleLatex.substring(sBas.length());
                    String sHaut = Formule.choixBlocMacroAtome(psFormuleLatex, "\\^", '^');
                    psFormuleLatex = psFormuleLatex.substring(sHaut.length());
                    if (sFlux.equals("\\int")) {
                        oLaFormule = Formule.creationFormule(oLaFormule, new FormuleIntegrale(Formule.parse(sBas), Formule.parse(sHaut)), psFormuleLatex);
                    } else if (sFlux.equals("\\prod")) {
                        oLaFormule = Formule.creationFormule(oLaFormule, new FormuleProduit(Formule.parse(sBas), Formule.parse(sHaut)), psFormuleLatex);
                    } else if (sFlux.equals("\\sum")) {
                        oLaFormule = Formule.creationFormule(oLaFormule, new FormuleSomme(Formule.parse(sBas), Formule.parse(sHaut)), psFormuleLatex);
                    }
                }
                sFlux = "";
                continue;
            }
            iPosit = Formule.parsing("^\\\\[a-zA-Z]*", psFormuleLatex);
            if (iPosit != -1) {
                String sParam = psFormuleLatex.substring(0, iPosit + 1);
                psFormuleLatex = psFormuleLatex.substring(sParam.length());
                iPosit = Formule.parsing("^\\\\(" + ListeSymboles.listeDesSymboles.getListeExpreg() + ")", sParam);
                if (iPosit != -1) {
                    if (iPosit + 1 != sParam.length()) {
                        psFormuleLatex = String.valueOf(sParam.substring(iPosit + 1)) + psFormuleLatex;
                    }
                    oLaFormule = Formule.creationFormule(oLaFormule, new FormuleSymbole(sParam.substring(0, iPosit + 1)), psFormuleLatex);
                    continue;
                }
                oLaFormule = Formule.creationFormule(oLaFormule, new FormuleAtomique(sParam), psFormuleLatex);
                continue;
            }
            iPosit = Formule.parsing("^[\\_\\^]{1}", psFormuleLatex);
            if (iPosit != -1) {
                sFlux = psFormuleLatex.substring(0, iPosit + 1);
                sBas = Formule.choixBlocMacroAtome(psFormuleLatex, "\\" + sFlux, sFlux.charAt(0));
                psFormuleLatex = psFormuleLatex.substring(sBas.length());
                if (!sBas.equals("")) {
                    sBas = Formule.suppressionDelimiteurs(sBas.substring(1));
                }
                if (sFlux.equals("_")) {
                    oLaFormule = Formule.creationFormule(oLaFormule, new FormuleIndice(Formule.parse(sBas)), psFormuleLatex);
                } else if (sFlux.equals("^")) {
                    oLaFormule = Formule.creationFormule(oLaFormule, new FormuleExposant(Formule.parse(sBas)), psFormuleLatex);
                }
                sFlux = "";
                continue;
            }
            iPosit = Formule.parsing("^[^\\\\\\{\\[\\_\\^\\}\\]]*", psFormuleLatex);
            if (iPosit != -1) {
                sFlux = psFormuleLatex.substring(0, iPosit + 1);
                psFormuleLatex = psFormuleLatex.substring(iPosit + 1);
                oLaFormule = Formule.creationFormule(oLaFormule, new FormuleAtomique(sFlux), psFormuleLatex);
                sFlux = "";
                continue;
            }
            switch (psFormuleLatex.charAt(0)) {
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    sFlux = String.valueOf(sFlux) + psFormuleLatex.substring(0, 1);
                    psFormuleLatex = psFormuleLatex.substring(1);
                }
            }
        }
        if (!sFlux.equals("")) {
            oLaFormule = Formule.creationFormule(oLaFormule, new FormuleAtomique(sFlux), psFormuleLatex);
        }
        return oLaFormule;
    }

    static Formule creationFormule(Formule poFormule, Formule poFormuleAjout, String psChaine) {
        if (psChaine.equals("")) {
            if (poFormule.getLesFormules().isEmpty()) {
                poFormule = poFormuleAjout;
            } else {
                poFormule.ajouterFormule(poFormuleAjout);
            }
        } else {
            poFormule.ajouterFormule(poFormuleAjout);
        }
        return poFormule;
    }

    static String suppressionDelimiteurs(String psChaine) {
        if (psChaine.equals("")) {
            return "";
        }
        String sRetour = psChaine.replaceFirst("^(\\{|\\[)", "");
        return sRetour.replaceFirst("(\\}|\\])$", "");
    }

    static int parsing(String psExpression, String psChaine) throws PatternSyntaxException {
        int iPosit = -1;
        Pattern oMotif = Pattern.compile(psExpression);
        Matcher oMatcher = oMotif.matcher(psChaine);
        if (oMatcher.find()) {
            iPosit = oMatcher.end() - 1;
        }
        return iPosit;
    }

    static String retourneBloc(char pcCharD, char pcCharF, String psChaine) {
        int iIndiceF = psChaine.indexOf(pcCharD) + 1;
        int iPosition = iIndiceF > 0 ? 1 : 0;
        while (iPosition != 0 && iIndiceF < psChaine.length()) {
            if (psChaine.charAt(iIndiceF) == pcCharD) {
                ++iPosition;
            }
            if (psChaine.charAt(iIndiceF) == pcCharF) {
                --iPosition;
            }
            ++iIndiceF;
        }
        return psChaine.substring(0, iIndiceF);
    }

    static String choixBlocMacroAtome(String psFormuleLatex, String psChar1, char pcChar2) {
        String sRetour = "";
        int iPosit = 0;
        iPosit = Formule.parsing("^\\s*" + psChar1 + '\\' + '{', psFormuleLatex);
        if (iPosit != -1) {
            sRetour = Formule.retourneBloc('{', '}', psFormuleLatex.substring(psFormuleLatex.indexOf("" + pcChar2)));
        } else {
            iPosit = Formule.parsing("^\\s*" + psChar1 + '\\' + '\\', psFormuleLatex);
            if (iPosit != -1) {
                if ((iPosit = Formule.parsing("^\\\\[a-zA-Z]*", psFormuleLatex.substring(iPosit))) != -1) {
                    sRetour = psFormuleLatex.substring(0, iPosit + 2);
                }
            } else {
                iPosit = Formule.parsing("^\\s*" + psChar1 + "[a-zA-Z0-9]{1}", psFormuleLatex);
                if (iPosit != -1) {
                    sRetour = psFormuleLatex.substring(0, iPosit + 1);
                } else if (psFormuleLatex.charAt(0) == pcChar2) {
                    sRetour = psFormuleLatex.substring(0, 1);
                }
            }
        }
        return sRetour;
    }
}

