/*
 * Decompiled with CFR 0.152.
 */
package panels;

import formules.Formule;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import panels.GestionMouse;
import panels.PanelFormuleAtomique;
import panels.PanelFormuleExposant;
import panels.PanelFormuleFraction;
import panels.PanelFormuleIndice;
import panels.PanelFormuleIntegrale;
import panels.PanelFormuleLimite;
import panels.PanelFormuleOperateur;
import panels.PanelFormuleProduit;
import panels.PanelFormuleRacine;
import panels.PanelFormuleSomme;
import panels.PanelFormuleSymbole;
import panels.PanelFormuleVecteur;
import panels.PanelGlobalFormule;
import panels.RectangleAccroche;
import symboles.ListeSymboles;
import symboles.NomFormules;

abstract class PanelFormule
extends JPanel
implements NomFormules,
Cloneable {
    static final int BASE_HAUTEUR = 20;
    static final int BASE_LARGEUR = 15;
    public static int ACCROCHE = 5;
    public static PanelFormule panelCourant = null;
    private PanelGlobalFormule oPanelRoot;
    private boolean isSuite = false;
    private boolean isActif = true;
    private boolean isAutonome = true;
    private GestionMouse oGM;
    private RectangleAccroche oRect;

    PanelFormule(PanelGlobalFormule poPanel) {
        this.setPanelRoot(poPanel);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.oRect = new RectangleAccroche(this);
        this.oGM = new GestionMouse(this);
        this.addMouseListener(this.oGM);
        this.setOpaque(false);
        this.setToolTipText(this.getName());
    }

    protected abstract int getHeight1();

    protected abstract int getHeight2();

    protected abstract int getHauteur();

    protected abstract int getLargeur();

    public abstract void ajouterPanel(PanelFormule var1);

    public abstract void ajouterPanel(int var1, PanelFormule var2);

    public abstract ArrayList getLesPanels();

    public abstract String getName();

    public abstract String getLatex();

    public void setPanelRoot(PanelGlobalFormule poPanel) {
        this.oPanelRoot = poPanel;
    }

    public PanelGlobalFormule getPanelRoot() {
        return this.oPanelRoot;
    }

    protected RectangleAccroche getRect() {
        return this.oRect;
    }

    protected void setActif(boolean pbActif) {
        this.isActif = pbActif;
    }

    protected boolean isActif() {
        return this.isActif;
    }

    protected boolean isCorrect() {
        return true;
    }

    protected void setAutonome(boolean pbAutonome) {
        this.isAutonome = pbAutonome;
    }

    protected boolean isAutonome() {
        return this.isAutonome;
    }

    protected void setSuite(boolean pbSuite) {
        this.isSuite = pbSuite;
    }

    protected boolean getSuite() {
        return this.isSuite;
    }

    protected Object clone() {
        return this;
    }

    protected void drawSymbole(Graphics poG, String psSymbole) {
        FontMetrics oFM = poG.getFontMetrics();
        int iY = (this.getHauteur() - oFM.getHeight()) / 2;
        poG.drawString(psSymbole, 0, iY + oFM.getAscent() + oFM.getLeading());
    }

    protected void recalculeSaisie(PanelFormule poPanel) {
        Dimension oD = null;
        if (poPanel.getParent() != null && poPanel.getParent().getName() != null) {
            PanelFormule oParent = (PanelFormule)poPanel.getParent();
            if (oParent.getLesPanels() != null) {
                oD = oParent.getPreferredSize();
                oParent.setSize(oD);
                oParent.revalidate();
                this.recalculeSaisie(oParent);
            }
        } else {
            oD = poPanel.getPreferredSize();
            poPanel.setSize(oD);
            poPanel.revalidate();
        }
    }

    protected boolean toutEstCorrect() {
        boolean bRetour = this.isCorrect();
        if (this.getLesPanels() != null && bRetour) {
            Iterator it = this.getLesPanels().iterator();
            while (it.hasNext() && bRetour) {
                PanelFormule obj = (PanelFormule)it.next();
                if (obj == null) continue;
                bRetour = obj.toutEstCorrect();
            }
        }
        return bRetour;
    }

    protected void recalculeVersFils() {
        if (this.getLesPanels() != null) {
            Iterator it = this.getLesPanels().iterator();
            while (it.hasNext()) {
                PanelFormule obj = (PanelFormule)it.next();
                if (obj == null) continue;
                obj.recalculeVersFils();
            }
        }
        this.setSize(this.getPreferredSize());
    }

    protected void recalculeVersPere() {
        this.setSize(this.getPreferredSize());
        this.revalidate();
        if (this.getParent() != null && this.getParent().getName() != null) {
            PanelFormule oParent = (PanelFormule)this.getParent();
            oParent.recalculeVersPere();
        }
    }

    public static PanelFormule createPanel(PanelGlobalFormule poPanel, Formule poFormule) {
        PanelFormule oPanel = null;
        if (poFormule != null) {
            if (poFormule.getName().equals("Fraction")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleFraction(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0)), PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(1))));
            } else if (poFormule.getName().equals("Integrale")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleIntegrale(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0)), PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(1))));
            } else if (poFormule.getName().equals("Produit")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleProduit(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0)), PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(1))));
            } else if (poFormule.getName().equals("Somme")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleSomme(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0)), PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(1))));
            } else if (poFormule.getName().equals("Racine")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleRacine(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0)), PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(1))));
            } else if (poFormule.getName().equals("Vecteur")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleVecteur(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0))));
            } else if (poFormule.getName().equals("Limite")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleLimite(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0))));
            } else if (poFormule.getName().equals("Indice")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleIndice(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0))));
            } else if (poFormule.getName().equals("Exposant")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleExposant(poPanel, PanelFormule.createPanel(poPanel, (Formule)poFormule.getLesFormules().get(0))));
            } else if (poFormule.getName().equals("Operateur")) {
                PanelFormule oPanelOp = null;
                Iterator it = poFormule.getLesFormules().iterator();
                while (it.hasNext()) {
                    Formule obj = (Formule)it.next();
                    if (oPanelOp == null) {
                        oPanelOp = new PanelFormuleOperateur(poPanel, PanelFormule.createPanel(poPanel, obj));
                        continue;
                    }
                    ((PanelFormuleOperateur)oPanelOp).ajouterUnPanel(PanelFormule.createPanel(poPanel, obj));
                }
                oPanelOp.setActif(false);
                oPanel = PanelFormule.affecterPanel(oPanel, oPanelOp);
            } else if (poFormule.getName().equals("Atomique")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleAtomique(poPanel, poFormule.getFormuleLatex()));
            } else if (poFormule.getName().equals("Symbole")) {
                oPanel = PanelFormule.affecterPanel(oPanel, new PanelFormuleSymbole(poPanel, ListeSymboles.listeDesSymboles.getValueListeSK(poFormule.getFormuleLatex().substring(1)).toString()));
            }
        }
        return oPanel;
    }

    static PanelFormule affecterPanel(PanelFormule poPanel, PanelFormule poPanelAjout) {
        if (poPanel == null || poPanel.getLesPanels().isEmpty()) {
            poPanel = poPanelAjout;
        } else {
            poPanel.ajouterPanel(poPanelAjout);
        }
        return poPanel;
    }
}

