/*
 * Decompiled with CFR 0.152.
 */
package panels;

import formules.Formule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import panels.PanelFormule;
import panels.PanelFormuleAtomique;
import panels.PanelFormuleExposant;
import panels.PanelFormuleFraction;
import panels.PanelFormuleIndice;
import panels.PanelFormuleIntegrale;
import panels.PanelFormuleLimite;
import panels.PanelFormuleOperateur;
import panels.PanelFormuleProduit;
import panels.PanelFormuleRacine;
import panels.PanelFormuleSomme;
import panels.PanelFormuleSymbole;
import panels.PanelFormuleVecteur;
import symboles.ListeSymboles;

public class PanelGlobalFormule
extends JPanel
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    static final String INIT_TEXTAREA = "Ecrivez ici votre formule LaTeX";
    static final String INIT_COMBO_SYMBOLE = "Liste des symboles";
    static final String INIT_LABEL = "Formule en cours : ";
    static final boolean BUT_ACTIF = true;
    static final boolean BUT_INACTIF = false;
    private String repertoireCourant = "";
    private String[] sToggleButton = new String[]{"\u00bd fraction", "\u221a racine", "\u2082 indice", "\u00b2 exposant", "\u222b int\u00e9grale", "\u03a0 produit", "\u03a3 somme", "\u2192 vecteur", "limite", "op\u00e9rateur"};
    private int iNbToggleButton = this.sToggleButton.length;
    private JButton[] oToggleButon = new JButton[this.iNbToggleButton];
    private static final int B_MODE = 5;
    private static final int B_EFFACER = 4;
    private static final int B_OUVRIR = 0;
    private static final int B_ENREG = 1;
    private static final int B_EDITER = 3;
    private String[] sButton = new String[]{"Ouvrir", "Enregistrer", "", "\u00e9diter", "Effacer", "Mode : EDIT"};
    private int iNbButton = this.sButton.length;
    private JButton[] oButton = new JButton[this.iNbButton];
    private String[] sBulleButton = new String[]{"Ouvrir un fichier au format .tex", "Enregistrer un fichier au format .tex", "", "Editer la formule LaTeX que vous avez saisie", "Effacer la formule", "Mode d'affichage"};
    private JComboBox jcSymboles = new JComboBox();
    private JLabel oLabel = new JLabel("Formule en cours : aucune");
    private JTextArea texteLatex = new JTextArea("Ecrivez ici votre formule LaTeX", 3, 40);
    private JPanel panelGraphique;

    public PanelGlobalFormule() {
        this.setLayout(new BorderLayout());
        JPanel panelEdition = new JPanel();
        panelEdition.setLayout(new BorderLayout());
        this.panelGraphique = new JPanel();
        this.panelGraphique.setLayout(new FlowLayout(1, 0, 20));
        this.panelGraphique.setOpaque(false);
        panelEdition.add("Center", this.panelGraphique);
        JToolBar oBarreBouton = new JToolBar(0);
        oBarreBouton.setLayout(new BorderLayout());
        oBarreBouton.setFloatable(false);
        JToolBar panelToggleBouton = new JToolBar();
        panelToggleBouton.setFloatable(false);
        int i = 0;
        while (i < this.sToggleButton.length) {
            this.oToggleButon[i] = new JButton(this.sToggleButton[i]);
            this.oToggleButon[i].setCursor(Cursor.getPredefinedCursor(12));
            this.oToggleButon[i].addActionListener(this);
            panelToggleBouton.add(this.oToggleButon[i]);
            ++i;
        }
        JToolBar panelBouton = new JToolBar();
        panelBouton.setFloatable(false);
        int i2 = 0;
        while (i2 < this.sButton.length) {
            if (this.sButton[i2].equals("")) {
                panelBouton.addSeparator();
            } else {
                this.oButton[i2] = new JButton(this.sButton[i2]);
                this.oButton[i2].addActionListener(this);
                this.oButton[i2].setCursor(Cursor.getPredefinedCursor(12));
                this.oButton[i2].setToolTipText(this.sBulleButton[i2]);
                panelBouton.add(this.oButton[i2]);
            }
            ++i2;
        }
        panelBouton.addSeparator();
        panelBouton.add(this.oLabel);
        panelBouton.addSeparator();
        this.jcSymboles.setCursor(Cursor.getPredefinedCursor(12));
        this.jcSymboles.addItem(INIT_COMBO_SYMBOLE);
        i2 = 0;
        while (i2 < ListeSymboles.listeDesSymboles.getTableLibelles().size()) {
            this.jcSymboles.addItem(ListeSymboles.listeDesSymboles.getTableLibelles().get(i2));
            ++i2;
        }
        this.jcSymboles.addItemListener(this);
        panelBouton.add(this.jcSymboles);
        oBarreBouton.add("North", panelBouton);
        oBarreBouton.add("South", panelToggleBouton);
        this.texteLatex.setLineWrap(true);
        this.texteLatex.setBorder(new LineBorder(Color.GRAY, 1));
        this.texteLatex.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                PanelGlobalFormule.this.oButton[3].setEnabled(PanelGlobalFormule.this.texteLatex.isEditable());
            }

            public void removeUpdate(DocumentEvent e) {
                PanelGlobalFormule.this.oButton[3].setEnabled(PanelGlobalFormule.this.texteLatex.isEditable());
            }
        });
        this.add("North", oBarreBouton);
        this.add("Center", panelEdition);
        this.add("South", this.texteLatex);
        this.changeEtatBoutons(false);
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        PanelFormule.panelCourant = null;
        if (s.equals("\u00e9diter")) {
            this.changeEtatBoutons(true);
            this.editerFormulelatex();
        } else if (s.equals("Ouvrir")) {
            if (this.ouvrirFichierTex()) {
                this.changeEtatBoutons(true);
            }
        } else if (s.equals("Enregistrer")) {
            if (((PanelFormule)this.panelGraphique.getComponent(0)).toutEstCorrect()) {
                this.enregistrerFichierTex();
            } else {
                JOptionPane.showMessageDialog(this, "Votre formule est incompl\u00e8te !!", "Avertissement", 1);
            }
        } else if (s.contains("Mode")) {
            if (this.panelGraphique.getComponentCount() > 0) {
                PanelFormule.ACCROCHE = PanelFormule.ACCROCHE == 0 ? 5 : 0;
                ((PanelFormule)this.panelGraphique.getComponent(0)).recalculeVersFils();
                this.panelGraphique.revalidate();
                ((JButton)e.getSource()).setText("Mode : " + (PanelFormule.ACCROCHE == 0 ? "MATHS" : "EDIT"));
            }
        } else if (s.equals("Effacer")) {
            int iRetour = JOptionPane.showConfirmDialog(this, "Voulez-vous effacer la formule ?", "Effacement", 0, 3);
            if (iRetour == 0) {
                this.effacerPanel();
                this.texteLatex.setText(INIT_TEXTAREA);
                this.changeEtatBoutons(false);
            }
        } else if (s.contains("fraction")) {
            PanelFormule.panelCourant = new PanelFormuleFraction(this, new PanelFormuleAtomique(this), new PanelFormuleAtomique(this));
        } else if (s.contains("racine")) {
            PanelFormule.panelCourant = new PanelFormuleRacine(this, new PanelFormuleAtomique(this), new PanelFormuleAtomique(this));
        } else if (s.contains("vecteur")) {
            PanelFormule.panelCourant = new PanelFormuleVecteur(this, new PanelFormuleAtomique(this));
        } else if (s.contains("op\u00e9rateur")) {
            PanelFormule.panelCourant = new PanelFormuleAtomique(this);
        } else if (s.contains("indice")) {
            PanelFormule.panelCourant = new PanelFormuleIndice(this, new PanelFormuleAtomique(this));
        } else if (s.contains("exposant")) {
            PanelFormule.panelCourant = new PanelFormuleExposant(this, new PanelFormuleAtomique(this));
        } else if (s.contains("limite")) {
            PanelFormule.panelCourant = new PanelFormuleLimite(this, new PanelFormuleIndice(this, new PanelFormuleAtomique(this)));
        } else if (s.contains("int\u00e9grale")) {
            PanelFormule.panelCourant = new PanelFormuleIntegrale(this, new PanelFormuleIndice(this, new PanelFormuleAtomique(this)), new PanelFormuleExposant(this, new PanelFormuleAtomique(this)));
        } else if (s.contains("produit")) {
            PanelFormule.panelCourant = new PanelFormuleProduit(this, new PanelFormuleIndice(this, new PanelFormuleAtomique(this)), new PanelFormuleExposant(this, new PanelFormuleAtomique(this)));
        } else if (s.contains("somme")) {
            PanelFormule.panelCourant = new PanelFormuleSomme(this, new PanelFormuleIndice(this, new PanelFormuleAtomique(this)), new PanelFormuleExposant(this, new PanelFormuleAtomique(this)));
        }
        this.greffePanel();
    }

    public void itemStateChanged(ItemEvent e) {
        String s = e.getSource().toString();
        if (e.getStateChange() == 1 && s.contains("JComboBox") && !e.getItem().equals(INIT_COMBO_SYMBOLE)) {
            String sChar = e.getItem().toString();
            PanelFormule.panelCourant = new PanelFormuleSymbole(this, "" + sChar.charAt(0));
            this.greffePanel();
        }
    }

    private void greffePanel() {
        if (PanelFormule.panelCourant != null && this.panelGraphique.getComponentCount() == 0) {
            PanelFormuleOperateur oPfo = new PanelFormuleOperateur(this, PanelFormule.panelCourant);
            oPfo.setActif(false);
            this.panelGraphique.add(oPfo);
            PanelFormule.panelCourant.recalculeVersPere();
            this.texteLatex.setText(PanelFormule.panelCourant.getLatex());
            PanelFormule.panelCourant = null;
            this.changeEtatBoutons(true);
        }
        this.afficheLabel();
    }

    protected void afficheLabel() {
        this.oLabel.setText(INIT_LABEL + (PanelFormule.panelCourant != null ? PanelFormule.panelCourant.getName() : "aucune"));
    }

    protected void afficheFormuleLatex() {
        String sChaine = "";
        int i = 0;
        while (i < this.panelGraphique.getComponentCount()) {
            sChaine = String.valueOf(sChaine) + ((PanelFormule)this.panelGraphique.getComponent(i)).getLatex();
            ++i;
        }
        this.texteLatex.setText(sChaine);
    }

    private void changeEtatBoutons(boolean pbEtat) {
        this.oButton[0].setEnabled(true);
        this.oButton[1].setEnabled(pbEtat);
        this.oButton[5].setEnabled(pbEtat);
        this.oButton[4].setEnabled(pbEtat);
        this.oButton[3].setEnabled(!pbEtat);
        this.texteLatex.setEditable(!pbEtat);
    }

    public void editerFormulelatex() {
        Formule oF = Formule.parse(this.texteLatex.getText());
        this.texteLatex.setText(oF.getFormuleLatex());
        PanelFormule oPf = PanelFormule.createPanel(this, oF);
        this.panelGraphique.add(oPf);
        oPf.setPanelRoot(this);
        oPf.recalculeVersFils();
        this.panelGraphique.revalidate();
        this.texteLatex.setText(oF.getFormuleLatex());
    }

    private void effacerPanel() {
        if (this.panelGraphique.getComponentCount() > 0) {
            this.panelGraphique.removeAll();
            this.panelGraphique.repaint();
        }
    }

    private String getNomFichier(String psNom, String psExtension) {
        return "FLatex" + psNom + "." + psExtension;
    }

    private String plusSeparateur(String psChaine) {
        return psChaine.trim().equals("") ? "" : "\\";
    }

    public boolean ouvrirFichierTex() {
        JFileChooser oFic = new JFileChooser();
        oFic.setSelectedFile(new File(String.valueOf(this.repertoireCourant) + this.plusSeparateur(this.repertoireCourant) + this.getNomFichier("String", "tex")));
        int iRetour = oFic.showOpenDialog(this);
        if (iRetour != 1 && oFic.isFileSelectionEnabled()) {
            this.repertoireCourant = oFic.getCurrentDirectory().getAbsolutePath();
            this.texteLatex.setText(this.chargerStringFormule(oFic.getSelectedFile().toString(), "$"));
            this.effacerPanel();
            this.editerFormulelatex();
        }
        return iRetour != 1;
    }

    private boolean enregistrerFichierTex() {
        JFileChooser oFic = new JFileChooser();
        oFic.setSelectedFile(new File(String.valueOf(this.repertoireCourant) + this.plusSeparateur(this.repertoireCourant) + this.getNomFichier("String", "tex")));
        int iRetour = oFic.showSaveDialog(this);
        if (iRetour != 1 && oFic.isFileSelectionEnabled()) {
            this.repertoireCourant = oFic.getCurrentDirectory().getAbsolutePath();
            this.enregistrerStringFormule(oFic.getSelectedFile().toString(), this.texteLatex.getText(), "$");
        }
        return iRetour != 1;
    }

    private void enregistrerStringFormule(String psFichier, String psFormule, String psChaine) {
        try {
            File oFichier = new File(psFichier);
            FileOutputStream oFos = new FileOutputStream(oFichier);
            DataOutputStream oOos = new DataOutputStream(oFos);
            oOos.writeUTF(String.valueOf(psChaine) + psFormule + psChaine);
            oOos.close();
        }
        catch (Exception e) {
            System.out.println("erreur " + e.getMessage());
        }
    }

    private String chargerStringFormule(String psFichier, String psChaine) {
        String sRetour = "";
        try {
            File oFichier = new File(psFichier);
            FileInputStream oFos = new FileInputStream(oFichier);
            DataInputStream oOos = new DataInputStream(oFos);
            sRetour = oOos.readUTF();
            oOos.close();
        }
        catch (Exception e) {
            System.out.println("erreur " + e.getMessage());
        }
        return sRetour.substring(sRetour.indexOf(psChaine) + 1, sRetour.lastIndexOf(psChaine));
    }
}

